amax1 = 20;
amin1 = amin-0.1;

figure4 = figure('units','centimeters','outerposition',[10 10 15 30]);
subplot(3,1,1)
plot(a,adot(:,1,ir),'b',a,adot(:,2,ir),'r',a,adot(:,3,ir),'g',a,adot(:,4,ir),'y',linspace(amin1,amax1,I),zeros(1,I),'k--','LineWidth',2)
legend('s_1(a)','s_2(a)','s_3(a)','s_4(a)','Location','NorthEast')
legend('boxoff','nofill')
%text(-0.155,-.105,'$\underline{a}$','FontSize',16,'interpreter','latex')
line([amin amin], [-.1 .08],'Color','Black','LineStyle','--')
xlabel('Wealth, $a$','interpreter','latex')
ylabel('Savings, $s_i(a)$','interpreter','latex')
xlim([amin1 amax1])
%ylim([-0.03 0.05])
set(gca,'FontSize',16)

subplot(3,1,2)
plot(a,c(:,1),'b',a,c(:,2),'r',a,c(:,3),'g',a,c(:,4),'y',linspace(amin1,amax1,I),zeros(1,I),'k--','LineWidth',2)
legend('c_1(a)','c_2(a)','c_3(a)','c_4(a)','Location','NorthEast')
legend('boxoff','nofill')
%text(-0.155,-.105,'$\underline{a}$','FontSize',16,'interpreter','latex')
line([amin amin], [-.1 .08],'Color','Black','LineStyle','--')
xlabel('Wealth, $a$','interpreter','latex')
ylabel('Consumption, $c_i(a)$','interpreter','latex')
xlim([amin1 amax1])
%ylim([-0.03 0.05])
set(gca,'FontSize',16)

subplot(3,1,3)
h1 = plot(a,g_r(:,1,ir)*amax/I,'b',a,g_r(:,2,ir)*amax/I,'r',a,g_r(:,3,ir)*amax/I,'g',a,g_r(:,4,ir)*amax/I,'y', 'LineWidth',2);
legend(h1,'g_1(a)','g_2(a)','g_3(a)','g_4(a)')
legend('boxoff','nofill')
%text(-0.155,-.12,'$\underline{a}$','FontSize',16,'interpreter','latex')
line([amin amin], [0 max(max(g_r(:,:,ir)))],'Color','Black','LineStyle','--')
xlabel('Wealth, $a$','interpreter','latex')
ylabel('Densities, $g_i(a)$','interpreter','latex')
xlim([amin1 amax1])
ylim([0 0.05])
set(gca,'FontSize',16)

set(gcf, 'Color', 'w');
if  gov_b == 0.3;
    export_fig EQM_low_debt.pdf 
elseif gov_b == 0.9;
    export_fig EQM_high_debt.pdf  
else
    disp('Govt debt not 30 or 90%. Figure not exported')
end 